require 'page-object'
require 'base'

class Direct_Scheduling < Base
  include PageObject
  def initialize(driver)
    super(driver)
  end

  h4(:type_of_care_table_title, :id=>"clinic-profile-based-on-types-of-care-heading")
  span(:required_field_label, :css=>".manage-settings-content > span[required-field]")
  h3(:direct_scheduling_settings_heading, :id=>"direct-scheduling-settings-heading")
  p(:instructional_text, :css=>".manage-settings-content > p")

#Primary Care
  span(:primarycareOption, :css => ".list-table ul li:nth-child(1) span:nth-child(2) .cell-content")
  span(:primarycareOptionLastSeen, :css => ".list-table ul li:nth-child(1) > span:nth-child(3)")

  select_list(:primaryCare, :css => "#primary-care-direct-scheduling-supported")
  select_list(:audiology, :id => "audiology-direct-scheduling-supported")
  select_list(:optometry, :id => "optometry-direct-scheduling-supported")
  select_list(:outpatientMentalHealth, :id => "outpatient-mental-health-direct-scheduling-supported")


#Last seen within (months) column
  select_list(:audiologyLastSeen, :id => "audiology-direct-scheduling-last-seen")
  select_list(:optometryLastSeen, :id => "optometry-direct-scheduling-last-seen")
  select_list(:outpatientMentalHealthLastSeen, :id => "outpatient-mental-health-direct-scheduling-last-seen")

#Can Cancel? column
  select_list(:primaryCareCanCancel, :id => "primary-care-direct-scheduling-can-cancel")
  select_list(:audiologyCanCancel, :id => "audiology-direct-scheduling-can-cancel")
  select_list(:optometryCanCancel, :id => "optometry-direct-scheduling-can-cancel")
  select_list(:outpatientMentalHealthCanCancel, :id => "outpatient-mental-health-direct-scheduling-can-cancel")

#Buttons
  button(:topCancel, :css => "#top-reset-btn")
  button(:topSave, :id => "top-save-btn")
  button(:bottomCancel, :id => "bottom-reset-btn")
  button(:bottomSave, :id => "bottom-save-btn")

  ul(:error_message,:css =>"body > div.container-fluid.ng-scope > div.main-content.ng-scope.snap-content > div.full-height.ng-scope > div.col-xs-12.column.primary-content.ng-scope.col-sm-9 > div.manage-settings-content.ng-scope > form > div.validation-summary.alert.alert-danger.text-left.ng-scope > ul")

end



